
import gurobi

def solve_donut_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    R = model.addVar(lb=0, name="Regular_Donuts", vtype=gurobi.GRB.CONTINUOUS)
    J = model.addVar(lb=0, name="Jelly_Filled_Donuts", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize profit
    model.setObjective(2*R + 3*J, gurobi.GRB.MAXIMIZE)

    # Demand constraint
    model.addConstr(R + J <= 1000, name="Demand_Constraint")

    # Budget constraint
    model.addConstr(4*R + 6*J <= 5000, name="Budget_Constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Regular Donuts = {R.varValue}, Jelly-filled Donuts = {J.varValue}")
        print(f"Maximum Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_donut_problem()
