
import gurobipy as gp

# Create a new model
model = gp.Model("BakeryOptimization")

# Create decision variables
x = model.addVar(vtype=gp.GRB.CONTINUOUS, name="pancakes")  # Number of pancake batches
y = model.addVar(vtype=gp.GRB.CONTINUOUS, name="bagels")  # Number of bagel batches

# Set the objective function
model.setObjective(25*x + 30*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(25*x + 9*y <= 150, "Daniel_Time")
model.addConstr(15*x + 20*y <= 175, "David_Time")  # Corrected David's available time
model.addConstr(x >= 0, "Pancakes_NonNegative")
model.addConstr(y >= 0, "Bagels_NonNegative")


# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of pancake batches (x): {x.x}")
    print(f"Number of bagel batches (y): {y.x}")
    print(f"Maximum Profit: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

