
from gurobipy import *

# Create a new model
m = Model("Bakery_Optimization")

# Define the decision variables
P = m.addVar(vtype=GRB.INTEGER, name="pancakes")
B = m.addVar(vtype=GRB.INTEGER, name="bagels")

# Set the objective function: Maximize profit
m.setObjective(25*P + 30*B, GRB.MAXIMIZE)

# Add constraints
m.addConstr(25*P + 9*B <= 150, "Daniel's_time")
m.addConstr(15*P + 20*B <= 350, "David's_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of batches of pancakes: {P.x}")
    print(f"Number of batches of bagels: {B.x}")
    print(f"Maximum profit: ${25*P.x + 30*B.x:.2f}")
else:
    print("No optimal solution found")
