
import gurobipy as gp

# Create a new model
model = gp.Model("Pancakes_and_Bagels")

# Define the decision variables
x = model.addVar(lb=0, name="Pancakes")
y = model.addVar(lb=0, name="Bagels")

# Define the objective function
model.setObjective(25*x + 30*y, gp.GRB.MAXIMIZE)

# Add the constraints
model.addConstr(25*x + 9*y <= 150, name="Daniel_Time")
model.addConstr(15*x + 20*y <= 350, name="David_Time")

# Solve the model
model.optimize()

# Check if the model is optimized
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal batches of pancakes: {x.varValue}")
    print(f"Optimal batches of bagels: {y.varValue}")
    print(f"Maximal profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
