
import gurobipy as gp

# Create a new model
m = gp.Model("smoothie_optimization")

# Create decision variables
x = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x") # Peanut butter smoothies
y = m.addVar(vtype=gp.GRB.CONTINUOUS, name="y") # Almond butter smoothies

# Set objective function
m.setObjective(3*x + 5*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x <= 80, "peanut_butter_constraint")
m.addConstr(3*y <= 90, "almond_butter_constraint")
m.addConstr(3*x + 3*y <= 100, "milk_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of peanut butter smoothies (x): {x.x}")
    print(f"Number of almond butter smoothies (y): {y.x}")
    print(f"Maximum Profit: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

