
from gurobipy import *

# Create a new model
m = Model("Smoothie_Optimization")

# Define the decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="peanut_butter_smoothies", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="almond_butter_smoothies", lb=0)

# Set the objective function
m.setObjective(3*x + 5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x <= 80, "peanut_butter_constraint")
m.addConstr(3*y <= 90, "almond_butter_constraint")
m.addConstr(3*x + 3*y <= 100, "milk_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Peanut butter smoothies: {x.x}")
    print(f"Almond butter smoothies: {y.x}")
    print(f"Total profit: ${3*x.x + 5*y.x:.2f}")
else:
    print("No optimal solution found.")
