
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the decision variables
x = m.addVar(lb=0, name="peanut_butter_smoothies")
y = m.addVar(lb=0, name="almond_butter_smoothies")

# Define the objective function
m.setObjective(3*x + 5*y, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(2*x <= 80, name="peanut_butter_availability")
m.addConstr(3*y <= 90, name="almond_butter_availability")
m.addConstr(3*x + 3*y <= 100, name="milk_availability")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution:")
    print(f"Peanut butter smoothies: {x.varValue}")
    print(f"Almond butter smoothies: {y.varValue}")
    print(f"Max profit: {m.objVal}")
else:
    print("No optimal solution found")
