
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("diet_optimization")

# Define decision variables
chicken = m.addVar(lb=0, name="chicken")
pork = m.addVar(lb=0, name="pork")

# Set objective function (minimize cost)
m.setObjective(10 * chicken + 15 * pork, GRB.MINIMIZE)

# Add constraints for macro-nutrient requirements
m.addConstr(20 * chicken + 15 * pork >= 100, "protein_req")
m.addConstr(5 * chicken + 3 * pork >= 50, "carb_req")
m.addConstr(6 * chicken + 8 * pork >= 30, "fat_req")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${m.objVal:.2f}")
    print(f"Chicken servings: {chicken.x:.2f}")
    print(f"Pork servings: {pork.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status {m.status}")

