
import gurobi

def solve_diet_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x_c = model.addVar(name="chicken", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # Servings of chicken
    x_p = model.addVar(name="pork", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # Servings of pork

    # Objective function: minimize cost
    model.setObjective(10 * x_c + 15 * x_p, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(20 * x_c + 15 * x_p >= 100, name="protein_requirement")  # Protein
    model.addConstr(5 * x_c + 3 * x_p >= 50, name="carbohydrate_requirement")  # Carbohydrates
    model.addConstr(6 * x_c + 8 * x_p >= 30, name="fat_requirement")  # Fat

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal servings of chicken: {x_c.varValue}")
        print(f"Optimal servings of pork: {x_p.varValue}")
        print(f"Total cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_diet_problem()
