
from gurobipy import Model, GRB

# Create a new model
m = Model("Math Contest")

# Create variables
a = m.addVar(vtype=GRB.INTEGER, name="algebra")
c = m.addVar(vtype=GRB.INTEGER, name="calculus")

# Set objective
m.setObjective(a + 3 * c, GRB.MAXIMIZE)

# Add constraints
m.addConstr(a + c <= 25, "Total questions")
m.addConstr(a >= 10, "Minimum algebra")
m.addConstr(c >= 6, "Minimum calculus")
m.addConstr(a <= 15, "Maximum algebra")
m.addConstr(c <= 15, "Maximum calculus")

# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Maximum score: {m.objVal}")
    print(f"Number of algebra questions: {a.x}")
    print(f"Number of calculus questions: {c.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

