
from gurobipy import *

# Create a new model
m = Model("Math_Contest")

# Define variables
A = m.addVar(lb=10, ub=15, vtype=GRB.INTEGER, name="Algebra_Questions")
C = m.addVar(lb=6, ub=15, vtype=GRB.INTEGER, name="Calculus_Questions")

# Objective function: Maximize the total score
m.setObjective(A + 3*C, GRB.MAXIMIZE)

# Constraints
m.addConstr(A + C <= 25, name="Total_Questions")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Maximum Score: {m.objVal}")
    print(f"Algebra Questions: {A.x}")
    print(f"Calculus Questions: {C.x}")
else:
    print("Model is infeasible")
