
import gurobi

def solve_contest_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    A = model.addVar(lb=0, ub=15, vtype=gurobi.GRB.INTEGER, name="Algebra")
    C = model.addVar(lb=0, ub=15, vtype=gurobi.GRB.INTEGER, name="Calculus")

    # Objective function: Maximize A + 3C
    model.setObjective(A + 3*C, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(A + C <= 25, name="Total_Questions")
    model.addConstr(A >= 10, name="Min_Algebra")
    model.addConstr(C >= 6, name="Min_Calculus")
    model.addConstr(A <= 15, name="Max_Algebra")
    model.addConstr(C <= 15, name="Max_Calculus")

    # Update model
    model.update()

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Algebra = {A.varValue}, Calculus = {C.varValue}")
        print(f"Maximum Score: {model.objVal}")
    else:
        print("The model is infeasible")

solve_contest_problem()
