
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("PaperProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="dotted_paper")
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="grid_paper")

# Set objective function
model.setObjective(5.5 * x + 11 * y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * x + 1.5 * y <= 3000, "cutting_constraint")
model.addConstr(5.5 * x + 7 * y <= 3000, "printing_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Dotted Paper (reams): {x.x}")
    print(f"Grid Paper (reams): {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

