
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x = model.addVar(lb=0, name="dotted_paper")
y = model.addVar(lb=0, name="grid_paper")

# Define the objective function
model.setObjective(5.5 * x + 11 * y, gurobi.GRB.MAXIMIZE)

# Define the constraints
cutting_machine_constraint = model.addConstr(3 * x + 1.5 * y <= 3000, name="cutting_machine")
printing_machine_constraint = model.addConstr(5.5 * x + 7 * y <= 3000, name="printing_machine")

# Optimize the model
model.optimize()

# Print the results
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Dotted paper: {x.varValue} reams")
    print(f"Grid paper: {y.varValue} reams")
    print(f"Max profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
