
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("lightbulb_production")

# Create decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="LED")
y = m.addVar(vtype=GRB.CONTINUOUS, name="Halogen")

# Set objective function
m.setObjective(30*x + 50*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x + 9*y <= 500, "plastics_constraint")
m.addConstr(12*x + 10*y <= 500, "wiring_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of LED packages: {x.x}")
    print(f"Number of Halogen packages: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

