
from gurobipy import *

# Create a new model
m = Model("Lightbulb_Production")

# Define the decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="LED")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Halogen")

# Define the objective function: Maximize profit
m.setObjective(30*x + 50*y, GRB.MAXIMIZE)

# Add constraints for plastics and wiring machines
m.addConstr(6*x + 9*y <= 500, "Plastics_Machine")
m.addConstr(12*x + 10*y <= 500, "Wiring_Machine")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
