
import gurobi

def solve_lightbulb_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="LED", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # Packages of LED lightbulbs
    y = model.addVar(name="Halogen", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # Packages of Halogen lightbulbs

    # Define the objective function
    model.setObjective(30*x + 50*y, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(6*x + 9*y <= 500, name="Plastics_Machine_Constraint")
    model.addConstr(12*x + 10*y <= 500, name="Wiring_Machine_Constraint")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: LED = {x.varValue}, Halogen = {y.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_lightbulb_problem()
