
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("meal_prep")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="breakfast") # Number of breakfast meals
y = m.addVar(vtype=GRB.INTEGER, name="lunch") # Number of lunch meals


# Set objective function
m.setObjective(10*x + 8*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x + 8*y <= 700, "prep_time")
m.addConstr(2*x + 3*y <= 500, "packaging_time")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of breakfast meals (x): {x.x}")
    print(f"Number of lunch meals (y): {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {m.status}")

