
from gurobipy import *

# Create a model
m = Model("Meal_Optimization")

# Define variables
B = m.addVar(vtype=GRB.INTEGER, name="Breakfast_Options", lb=0)
L = m.addVar(vtype=GRB.INTEGER, name="Lunch_Options", lb=0)

# Set the objective function
m.setObjective(10*B + 8*L, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*B + 8*L <= 700, "Preparation_Time")
m.addConstr(2*B + 3*L <= 500, "Packaging_Time")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Breakfast Options: {B.x}")
    print(f"Lunch Options: {L.x}")
    print(f"Maximum Profit: ${10*B.x + 8*L.x}")
else:
    print("No optimal solution found")
