
import gurobi

def solve_restaurant_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    B = model.addVar(lb=0, name="Breakfast")
    L = model.addVar(lb=0, name="Lunch")

    # Define the objective function
    model.setObjective(10*B + 8*L, gurobi.GRB.MAXIMIZE)

    # Add the preparation time constraint
    model.addConstr(7*B + 8*L <= 700, name="Preparation_Time")

    # Add the packaging time constraint
    model.addConstr(2*B + 3*L <= 500, name="Packaging_Time")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of breakfast options: {B.varValue}")
        print(f"Number of lunch options: {L.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_restaurant_problem()
