
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("movie_investment")

    # Create variables
    x = m.addVar(name="action_investment")  # Investment in action movie
    y = m.addVar(name="animation_investment") # Investment in animation movie

    # Set objective function
    m.setObjective(0.09 * x + 0.06 * y, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(x + y <= 500000, "budget")
    m.addConstr(y >= 3 * x, "investment_ratio")
    m.addConstr(y <= 400000, "animation_limit")

    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal investment in action movie: ${x.x}")
        print(f"Optimal investment in animation movie: ${y.x}")
        print(f"Maximum earnings: ${m.objVal}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
