
from gurobipy import *

# Create a new model
m = Model("Movie_Investment")

# Define variables
x = m.addVar(name="Action_Movie", vtype=GRB.CONTINUOUS, lb=0)
y = m.addVar(name="Animation_Movie", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function: Maximize earnings
m.setObjective(0.09*x + 0.06*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 500000, name="Total_Investment")
m.addConstr(y >= 3*x, name="Animation_vs_Action")
m.addConstr(y <= 400000, name="Max_Animation")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Action Movie Investment: ${x.x:.2f}")
    print(f"Animation Movie Investment: ${y.x:.2f}")
    print(f"Total Earnings: ${0.09*x.x + 0.06*y.x:.2f}")
else:
    print("No optimal solution found")
