
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="action_movie_investment", lb=0)
    y = model.addVar(name="animation_movie_investment", lb=0)

    # Objective function: Maximize earnings
    model.setObjective(0.09 * x + 0.06 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 500000, name="total_investment_constraint")
    model.addConstr(y >= 3 * x, name="animation_movie_investment_constraint")
    model.addConstr(y <= 400000, name="animation_movie_upper_limit_constraint")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in action movie: ${x.varValue:.2f}")
        print(f"Optimal investment in animation movie: ${y.varValue:.2f}")
        print(f"Maximized earnings: ${0.09 * x.varValue + 0.06 * y.varValue:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
