
import gurobipy as gp

# Create a new model
m = gp.Model("Investment_Problem")

# Create decision variables
x = m.addVar(nonnegative=True, name="solar_investment")
y = m.addVar(nonnegative=True, name="wind_investment")

# Set objective function
m.setObjective(0.10 * x + 0.09 * y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 6000, "total_investment")
m.addConstr(x >= 0.45 * 6000, "min_solar")
m.addConstr(y >= 3000, "min_wind")

# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution Found:")
    print(f"Invest ${x.x:.2f} in solar energy")
    print(f"Invest ${y.x:.2f} in wind energy")
    print(f"Maximum profit: ${m.objVal:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

