
from gurobipy import *

# Create a new model
m = Model("Energy_Investment")

# Create variables
x_s = m.addVar(lb=2700, name="Solar_Investment")  # Minimum of $2700
x_w = m.addVar(lb=3000, name="Wind_Investment")   # Minimum of $3000

# Objective function: Maximize profit
m.setObjective(0.10*x_s + 0.09*x_w, GRB.MAXIMIZE)

# Constraint: Total investment does not exceed $6000
m.addConstr(x_s + x_w <= 6000, name="Total_Investment")

# Since we want to use all funds for maximum profit,
# and given the minimums, this constraint ensures we're optimizing within bounds.
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Solar Investment: ${x_s.x}")
    print(f"Wind Investment: ${x_w.x}")
    print(f"Total Profit: ${0.10*x_s.x + 0.09*x_w.x}")
else:
    print("No optimal solution found.")
