
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x_s = model.addVar(lb=0, name="Solar_Investment")
    x_w = model.addVar(lb=0, name="Wind_Investment")

    # Objective function: Maximize profit
    model.setObjective(0.10 * x_s + 0.09 * x_w, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x_s + x_w <= 6000, name="Total_Investment")
    model.addConstr(0.55 * x_s - 0.45 * x_w >= 0, name="Solar_Min_Investment")
    model.addConstr(x_w >= 3000, name="Wind_Min_Investment")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in solar: ${x_s.varValue:.2f}")
        print(f"Optimal investment in wind: ${x_w.varValue:.2f}")
        print(f"Max Profit: ${0.10 * x_s.varValue + 0.09 * x_w.varValue:.2f}")
    else:
        print("The problem is infeasible")

solve_investment_problem()
