
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("clothing_production")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="coats")  # Number of coats
y = m.addVar(vtype=GRB.CONTINUOUS, name="shirts") # Number of shirts

# Set objective function
m.setObjective(6*x + 11*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.7*x + 0.2*y <= 50, "measuring")
m.addConstr(0.5*x + 0.3*y <= 35, "cutting")
m.addConstr(0.9*x + 0.5*y <= 40, "sewing")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Coats to Produce: {x.x}")
    print(f"Number of Shirts to Produce: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

