
from gurobipy import *

# Create a new model
m = Model("Clothing_Company")

# Define variables
C = m.addVar(vtype=GRB.CONTINUOUS, name="Coats", lb=0)
S = m.addVar(vtype=GRB.CONTINUOUS, name="Shirts", lb=0)

# Set the objective function
m.setObjective(6*C + 11*S, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.7*C + 0.2*S <= 50, "Measuring_Team")
m.addConstr(0.5*C + 0.3*S <= 35, "Cutting_Team")
m.addConstr(0.9*C + 0.5*S <= 40, "Sewing_Team")

# Optimize model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
