
import gurobi

def solve_clothing_production_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    x_c = model.addVar(name="coats", lb=0, ub=None, obj=6)
    x_s = model.addVar(name="shirts", lb=0, ub=None, obj=11)

    # Define the constraints
    model.addConstr(x_c * 0.7 + x_s * 0.2 <= 50, name="measuring")
    model.addConstr(x_c * 0.5 + x_s * 0.3 <= 35, name="cutting")
    model.addConstr(x_c * 0.9 + x_s * 0.5 <= 40, name="sewing")

    # Set the objective function
    model.setObjective(x_c * 6 + x_s * 11, gurobi.GRB.MAXIMIZE)

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: {model.x[x_c].varName} = {model.x[x_c].x}, {model.x[x_s].varName} = {model.x[x_s].x}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found")

solve_clothing_production_problem()
