
import gurobipy as gp

# Create a new model
m = gp.Model("Investment_Optimization")

# Create variables
x1 = m.addVar(lb=0, name="Oil_and_Gas")
x2 = m.addVar(lb=0, name="Tech")
x3 = m.addVar(lb=0, name="Mining")
x4 = m.addVar(lb=0, name="Retail")

# Set objective function
m.setObjective(0.06*x1 + 0.08*x2 + 0.09*x3 + 0.11*x4, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 + x3 + x4 <= 1000000, "Budget")
m.addConstr(x4 <= x1, "Retail_vs_OilGas")
m.addConstr(x2 <= x3, "Tech_vs_Mining")
m.addConstr(x4 <= 0.28 * (x1 + x2 + x3 + x4), "Retail_Limit")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution Found:")
    print(f"Oil and Gas Investment: ${x1.x:.2f}")
    print(f"Tech Investment: ${x2.x:.2f}")
    print(f"Mining Investment: ${x3.x:.2f}")
    print(f"Retail Investment: ${x4.x:.2f}")
    print(f"Total Return: ${m.objVal:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

