
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define the variables
x1 = m.addVar(name="Oil_and_Gas", lb=0)
x2 = m.addVar(name="Tech", lb=0)
x3 = m.addVar(name="Mining", lb=0)
x4 = m.addVar(name="Retail", lb=0)

# Set the objective function
m.setObjective(0.06*x1 + 0.08*x2 + 0.09*x3 + 0.11*x4, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 + x3 + x4 <= 1000000, name="Total_Investment")
m.addConstr(x4 <= x1, name="Retail_vs_Oil_Gas")
m.addConstr(x2 <= x3, name="Tech_vs_Mining")
m.addConstr(x4 <= 0.28*(x1 + x2 + x3 + x4), name="Max_Retail_Percent")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Oil and Gas: {x1.x}")
    print(f"Tech: {x2.x}")
    print(f"Mining: {x3.x}")
    print(f"Retail: {x4.x}")
    print(f"Total Return: {m.objVal}")
else:
    print("No optimal solution found")
