
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x_og = model.addVar(lb=0, name="oil_and_gas")
    x_tech = model.addVar(lb=0, name="tech")
    x_mining = model.addVar(lb=0, name="mining")
    x_retail = model.addVar(lb=0, name="retail")

    # Objective function: Maximize return
    model.setObjective(0.06 * x_og + 0.08 * x_tech + 0.09 * x_mining + 0.11 * x_retail, gurobi.GRB.MAXIMIZE)

    # Total investment constraint
    model.addConstr(x_og + x_tech + x_mining + x_retail <= 1000000, name="total_investment")

    # Retail vs. Oil and Gas constraint
    model.addConstr(x_retail <= x_og, name="retail_vs_oil_and_gas")

    # Tech vs. Mining constraint
    model.addConstr(x_tech <= x_mining, name="tech_vs_mining")

    # Retail industry limit
    model.addConstr(x_retail <= 280000, name="retail_limit")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Oil and Gas: ${x_og.x:.2f}")
        print(f"Tech: ${x_tech.x:.2f}")
        print(f"Mining: ${x_mining.x:.2f}")
        print(f"Retail: ${x_retail.x:.2f}")
        print(f"Max Return: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
