
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Organic_Farming")

# Create decision variables
x = m.addVar(lb=0, name="daikons") # Acres of daikons
y = m.addVar(lb=0, name="fennels") # Acres of fennels

# Set objective function
m.setObjective(300*x + 250*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 300, "land")
m.addConstr(0.5*x + 1.5*y <= 500, "watering")
m.addConstr(70*x + 50*y <= 7400, "compost")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Revenue: ${m.objVal}")
    print(f"Acres of Daikons: {x.x}")
    print(f"Acres of Fennels: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

