
from gurobipy import *

# Create a model
m = Model("Organic_Farming")

# Define variables
daikons_acres = m.addVar(vtype=GRB.CONTINUOUS, name="Daikons_Acres", lb=0)
fennels_acres = m.addVar(vtype=GRB.CONTINUOUS, name="Fennels_Acres", lb=0)

# Define constraints
m.addConstr(daikons_acres + fennels_acres <= 300, "Land_Constraint")
m.addConstr(0.5*daikons_acres + 1.5*fennels_acres <= 500, "Watering_Time_Constraint")
m.addConstr(70*daikons_acres + 50*fennels_acres <= 7400, "Compost_Cost_Constraint")

# Define objective function
m.setObjective(300*daikons_acres + 250*fennels_acres, GRB.MAXIMIZE)

# Optimize model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print(f"Objective: {m.objVal}")

