
import gurobi

def organic_farming_optimization():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, name="daikon_acres")
    y = model.addVar(lb=0, name="fennel_acres")

    # Objective function: Maximize revenue
    model.setObjective(300*x + 250*y, gurobi.GRB.MAXIMIZE)

    # Land constraint
    model.addConstr(x + y <= 300, name="land_constraint")

    # Watering hours constraint
    model.addConstr(0.5*x + 1.5*y <= 500, name="watering_hours_constraint")

    # Compost constraint
    model.addConstr(70*x + 50*y <= 7400, name="compost_constraint")

    # Optimize
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal Solution:")
        print(f"Daikon Acres: {x.varValue}")
        print(f"Fennel Acres: {y.varValue}")
        print(f"Max Revenue: {model.objVal}")
    else:
        print("The model is infeasible.")

organic_farming_optimization()
