
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_mix")

# Create variables
x = m.addVar(lb=0, name="carrot_juice")
y = m.addVar(lb=0, name="lemon_juice")

# Set objective function
m.setObjective(3.5 * x + 6 * y, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * x + 3 * y >= 25, "vitamin_A")
m.addConstr(3 * x + 6 * y >= 25, "vitamin_B")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Carrot juice servings: {x.x:.2f}")
    print(f"Lemon juice servings: {y.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

