
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Define the decision variables
x1 = m.addVar(lb=0, name="carrot_juice")
x2 = m.addVar(lb=0, name="lemon_juice")

# Set the objective function
m.setObjective(3.5*x1 + 6*x2, GRB.MINIMIZE)

# Add constraints for vitamin A and B
m.addConstr(8*x1 + 3*x2 >= 25, "Vitamin_A")
m.addConstr(3*x1 + 6*x2 >= 25, "Vitamin_B")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Carrot Juice Servings: {x1.x}")
    print(f"Lemon Juice Servings: {x2.x}")
    print(f"Total Cost: ${3.5*x1.x + 6*x2.x:.2f}")
else:
    print("No optimal solution found")
