
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, name="carrot_juice_servings", vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(lb=0, name="lemon_juice_servings", vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(3.5 * x + 6 * y, gurobi.GRB.MINIMIZE)

    # Add the constraints
    model.addConstr(8 * x + 3 * y >= 25, name="vitamin_A_constraint")
    model.addConstr(3 * x + 6 * y >= 25, name="vitamin_B_constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print(f"Optimal solution found. Carrot juice servings: {x.varValue}, Lemon juice servings: {y.varValue}")
        print(f"Minimum cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

# Run the optimization problem
solve_optimization_problem()
