
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
x = m.addVar(lb=0, name="mushrooms") # Acres of mushrooms
y = m.addVar(lb=0, name="truffles") # Acres of truffles

# Set objective function
m.setObjective(200*x + 500*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 90, "land")
m.addConstr(80*x + 200*y <= 13500, "maintenance")
m.addConstr(2*x + 3*y <= 120, "time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} acres of mushrooms")
    print(f"Plant {y.x:.2f} acres of truffles")
    print(f"Maximum profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

