
from gurobipy import *

# Create a new model
m = Model("Farm_Optimization")

# Define the decision variables
M = m.addVar(vtype=GRB.CONTINUOUS, name="Mushrooms_Acres")
T = m.addVar(vtype=GRB.CONTINUOUS, name="Truffles_Acres")

# Objective function: Maximize profit
m.setObjective(200*M + 500*T, GRB.MAXIMIZE)

# Constraints
m.addConstr(80*M + 200*T <= 13500, "Maintenance_Cost")
m.addConstr(2*M + 3*T <= 120, "Care_Time")
m.addConstr(M + T <= 90, "Total_Land")
m.addConstr(M >= 0, "Non_Negativity_Mushrooms")
m.addConstr(T >= 0, "Non_Negativity_Truffles")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print(f"Objective (Max Profit): {m.objVal}")
