
import gurobi as gp

# Create a new model
m = gp.Model("Mushrooms_and_Truffles")

# Define the variables
x = m.addVar(lb=0, name="mushrooms")  # acres of mushrooms
y = m.addVar(lb=0, name="truffles")  # acres of truffles

# Objective function: Maximize profit
m.setObjective(200*x + 500*y, gp.GRB.MAXIMIZE)

# Land constraint
m.addConstr(x + y <= 90, name="land_constraint")

# Maintenance cost constraint
m.addConstr(80*x + 200*y <= 13500, name="maintenance_cost_constraint")

# Care hours constraint
m.addConstr(2*x + 3*y <= 120, name="care_hours_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal acres of mushrooms: {x.varValue}")
    print(f"Optimal acres of truffles: {y.varValue}")
    print(f"Maximal profit: {m.objVal}")
else:
    print("The model is infeasible")
