
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("exam_optimization")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="easy_questions")
y = m.addVar(vtype=GRB.INTEGER, name="hard_questions")

# Set objective
m.setObjective(4*x + 10*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x >= 4, "min_easy")
m.addConstr(y >= 2, "min_hard")
m.addConstr(x <= 12, "max_easy")
m.addConstr(y <= 4, "max_hard")
m.addConstr(x + y <= 9, "total_questions")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Easy questions: {x.x}")
    print(f"Hard questions: {y.x}")
    print(f"Total points: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

