
from gurobipy import *

# Create a new model
m = Model("Exam_Questions")

# Define the decision variables
x = m.addVar(lb=4, ub=12, vtype=GRB.INTEGER, name="easy_questions")
y = m.addVar(lb=2, ub=4, vtype=GRB.INTEGER, name="hard_questions")

# Set the objective function to maximize points
m.setObjective(4*x + 10*y, GRB.MAXIMIZE)

# Add the constraint for the total number of questions
m.addConstr(x + y <= 9, "total_questions")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Solve {x.x} easy questions")
    print(f"Solve {y.x} hard questions")
    print(f"Total points: {4*x.x + 10*y.x}")
else:
    print("No optimal solution found")
