
import gurobi

def solve_exam_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    E = model.addVar(lb=0, ub=12, name="Easy_Questions")
    H = model.addVar(lb=0, ub=4, name="Hard_Questions")

    # Objective function: Maximize 4E + 10H
    model.setObjective(4 * E + 10 * H, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(E >= 4, name="Min_Easy")
    model.addConstr(H >= 2, name="Min_Hard")
    model.addConstr(E <= 12, name="Max_Easy")
    model.addConstr(H <= 4, name="Max_Hard")
    model.addConstr(E + H <= 9, name="Total_Questions")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Easy questions = {E.varValue}, Hard questions = {H.varValue}")
        print(f"Maximum points: {4 * E.varValue + 10 * H.varValue}")
    else:
        print("No optimal solution found.")

solve_exam_problem()
