
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("investment_optimization")

# Create variables
x1 = m.addVar(lb=0, name="GPUs")
x2 = m.addVar(lb=0, name="CPUs")
x3 = m.addVar(lb=0, name="Software")
x4 = m.addVar(lb=0, name="Mobile")

# Set objective function
m.setObjective(0.04 * x1 + 0.06 * x2 + 0.11 * x3 + 0.08 * x4, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 + x3 + x4 <= 2000000, "budget")
m.addConstr(x1 <= 0.09 * 2000000, "GPU_limit")
m.addConstr(x1 <= x2, "GPU_vs_CPU")
m.addConstr(x4 <= x3, "Mobile_vs_Software")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal investment strategy:")
    print(f"  GPUs: ${x1.x:.2f}")
    print(f"  CPUs: ${x2.x:.2f}")
    print(f"  Software: ${x3.x:.2f}")
    print(f"  Mobile: ${x4.x:.2f}")
    print(f"Total Return: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

