
from gurobipy import *

# Create a new model
m = Model("Investment")

# Define variables
x_GPUs = m.addVar(lb=0, name="GPUs")
x_CPUs = m.addVar(lb=0, name="CPUs")
x_Software = m.addVar(lb=0, name="Software")
x_MobileDevices = m.addVar(lb=0, name="MobileDevices")

# Objective function: Maximize return
m.setObjective(0.04*x_GPUs + 0.06*x_CPUs + 0.11*x_Software + 0.08*x_MobileDevices, GRB.MAXIMIZE)

# Constraints
m.addConstr(x_GPUs + x_CPUs + x_Software + x_MobileDevices <= 2000000, "Total Investment")
m.addConstr(x_GPUs <= x_CPUs, "GPUs vs CPUs")
m.addConstr(x_MobileDevices <= x_Software, "Mobile Devices vs Software")
m.addConstr(x_GPUs <= 180000, "Max GPUs")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"GPUs: {x_GPUs.X}")
    print(f"CPUs: {x_CPUs.X}")
    print(f"Software: {x_Software.X}")
    print(f"Mobile Devices: {x_MobileDevices.X}")
else:
    print("No optimal solution found")
