
import gurobi

def martin_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    G = model.addVar(lb=0, name="GPUs")
    C = model.addVar(lb=0, name="CPUs")
    S = model.addVar(lb=0, name="software")
    M = model.addVar(lb=0, name="mobile_devices")

    # Objective function: Maximize return
    model.setObjective(0.04 * G + 0.06 * C + 0.11 * S + 0.08 * M, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(G <= C, name="GPUvsCPU")
    model.addConstr(M <= S, name="MobilevsSoftware")
    model.addConstr(G <= 0.09 * 2000000, name="GPU_limit")
    model.addConstr(G + C + S + M == 2000000, name="total_investment")

    # Solve the problem
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal investment amounts:")
        print(f"GPUs: ${G.varValue:.2f}")
        print(f"CPUs: ${C.varValue:.2f}")
        print(f"Software: ${S.varValue:.2f}")
        print(f"Mobile Devices: ${M.varValue:.2f}")
        print(f"Total return: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    martin_investment_problem()
