
import gurobipy as gp

# Create a new model
model = gp.Model("HoodieProfit")

# Create decision variables
z = model.addVar(vtype=gp.GRB.INTEGER, name="zippered_hoodies")
p = model.addVar(vtype=gp.GRB.INTEGER, name="pullover_hoodies")

# Set objective function
model.setObjective(5*z + 4*p, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*z + 15*p <= 450, "budget_constraint")
model.addConstr(z + p <= 25, "sales_limit_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Zippered Hoodies: {z.x}")
    print(f"Number of Pullover Hoodies: {p.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

