
from gurobipy import *

# Create a new model
m = Model("Hoodie_Optimization")

# Define the decision variables
Z = m.addVar(vtype=GRB.INTEGER, name="Zippered_Hoodies")
P = m.addVar(vtype=GRB.INTEGER, name="Pullover_Hoodies")

# Set the objective function to maximize profit
m.setObjective(5*Z + 4*P, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*Z + 15*P <= 450, "Budget_Constraint")
m.addConstr(Z + P <= 25, "Total_Hoodies_Constraint")

# Solve the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print(f"Profit: {m.objVal}")

