
import gurobi

def solve_hoodie_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables as integers
    Z = model.addVar(name="Zippered_Hoodies", lb=0, type=gurobi.GRB.INTEGER)
    P = model.addVar(name="Pullover_Hoodies", lb=0, type=gurobi.GRB.INTEGER)

    # Objective function: Maximize profit
    model.setObjective(5 * Z + 4 * P, gurobi.GRB.MAXIMIZE)

    # Cost constraint
    model.addConstr(20 * Z + 15 * P <= 450, name="Cost_Constraint")

    # Sales constraint
    model.addConstr(Z + P <= 25, name="Sales_Constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Zippered Hoodies = {Z.varValue}, Pullover Hoodies = {P.varValue}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_hoodie_problem()
